/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.util;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.platform.ModVersion;
import com.faboslav.friendsandfoes.platform.ProjectUrlProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public final class UpdateChecker {
    private static final Gson gson = new Gson();

    public static void checkForNewUpdatesInGame(class_746 clientPlayerEntity) {
        CompletableFuture.runAsync(() -> {
            if (!FriendsAndFoes.getConfig().checkForNewUpdates) {
                return;
            }
            ModuleDescriptor.Version latestVersion = UpdateChecker.getLatestVersion();
            if (latestVersion == null) {
                return;
            }
            String modVersion = ModVersion.getModVersion();
            if (modVersion == null) {
                return;
            }
            if (latestVersion.compareTo(ModuleDescriptor.Version.parse(modVersion)) <= 0) {
                return;
            }
            String updateMessageString = MessageFormat.format("Friend&Foes update is available! You are using {0} version, but the latest version is {1}. You can download it at ", modVersion, latestVersion.toString());
            class_5250 updateMessage = class_2561.method_43470((String)updateMessageString);
            class_5250 curseforgeLink = class_2561.method_43470((String)"CurseForge").method_27694(arg -> arg.method_10958(new class_2558(class_2558.class_2559.field_11749, ProjectUrlProvider.getCurseForgeProjectLink())).method_30938(Boolean.valueOf(true)));
            class_5250 updateMessageSecondPart = class_2561.method_43470((String)" or ");
            class_5250 modrinthLink = class_2561.method_43470((String)"Modrinth").method_27694(arg -> arg.method_10958(new class_2558(class_2558.class_2559.field_11749, ProjectUrlProvider.getModrinthProjectLink())).method_30938(Boolean.valueOf(true)));
            class_5250 updateMessageThirdPart = class_2561.method_43470((String)".");
            updateMessage.method_10852((class_2561)curseforgeLink).method_10852((class_2561)updateMessageSecondPart).method_10852((class_2561)modrinthLink).method_10852((class_2561)updateMessageThirdPart);
            clientPlayerEntity.method_7353((class_2561)updateMessage, false);
            FriendsAndFoes.getLogger().info("[Friends&Foes] An update is available! You are using {} version, but the latest version is {}.", (Object)modVersion, (Object)latestVersion.toString());
        });
    }

    public static void checkForNewUpdates() {
        CompletableFuture.runAsync(() -> {
            if (!FriendsAndFoes.getConfig().checkForNewUpdates) {
                return;
            }
            ModuleDescriptor.Version latestVersion = UpdateChecker.getLatestVersion();
            if (latestVersion == null) {
                return;
            }
            String modVersion = ModVersion.getModVersion();
            if (modVersion == null) {
                return;
            }
            if (latestVersion.compareTo(ModuleDescriptor.Version.parse(modVersion)) <= 0) {
                return;
            }
            FriendsAndFoes.getLogger().info("[Friends&Foes] An update is available! You are using {} version, but the latest version is {}.", (Object)modVersion, (Object)latestVersion.toString());
        });
    }

    @Nullable
    public static ModuleDescriptor.Version getLatestVersion() {
        String gameVersion;
        HttpResponse<String> response;
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://raw.githubusercontent.com/Faboslav/friends-and-foes/master/.github/versions.json")).build();
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
        if (response.statusCode() != 200) {
            return null;
        }
        JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
        if (!json.has(gameVersion = class_155.method_16673().getName())) {
            return null;
        }
        return ModuleDescriptor.Version.parse(json.get(gameVersion).getAsString());
    }
}

